<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
	<title>Lasso Examples Pack</title>
	<?LassoScript
		content_type('text/html; charset=UTF-8');
	?>
	<link rel="stylesheet" type="text/css" href="examples.css.lasso" />
	<style type="text/css">
		h2
		{ text-align: center; }
		ul
		{ list-style-type: none; }
		.descriptive_text
		{ 
	 	
		}
		.warning_text
		{ 
	 		color: red;
		}
		.documentation_link
		{
			font-size: 80%;
		}
		.example_description
		{
			padding-left: 30px;
			padding-right: 30px;
		}
		.examples_list
		{
			padding-left: 30px;
			padding-right: 30px;
			padding-bottom: 50px;
		}
	</style>
</head>
<body>
	<h2>Welcome to the Lasso Examples Pack</h2>
	<div class="examples_list">
		<p class="descriptive_text">These examples are designed to be instructive for both new users and experienced developers alike.</>
		[if: ((decimal: (lasso_version: -lassoversion)) < 8.0)]
			<p class="warning_text">Warning: These examples require Lasso Professional 8.  Lasso Professional 8.1 or higher is recommended.  You are running Lasso Professional [lasso_version: -lassoversion].</p>
		[/if]
	<?LassoScript
		local('lst' = file_listdirectory('.'));
		if: $lst->size == 0;
			'<p class="warning_text">Warning: No examples were found.  Check to be sure one or more examples folders have been installed and that Lasso has permission to read those folders. If you are running WebSTAR V you need to add * to list of File Tags Extensions in the Setup > Site > File Extensions section of Lasso Site Administration.</p>';
		/if;
		'<ul>';
		iterate(#lst, local('curr'));
			if (#curr->endsWith('/') && !#curr->beginsWith('.'));
				local('info'=null);
				protect;
					#info = xml(include_raw(#curr 'info.xml'));
					'<li><a href="' #curr #info->extractOne('/application/index-file/text()') '">'
						#info->extractOne('/application/title/text()') '</a>';
					local('docFile' = string(#info->extractOne('/application/documentation-file/text()')));
					if (!#docFile);
						#docFile = 'documentation.html';
					/if;
					if (#docFile && include_raw(#curr #docFile)->size);
						' - <i class="documentation_link"><a href="' #curr #docFile '">documentation</a></i>';
					/if;
					'<div class="example_description">' #info->extract('/application/description/*')->join('') '</div>'
					'</li>';
				/protect; // if we fail here, then there is no application in this folder
			/if;
		/iterate;
		'</ul>';
	?>
	</div>
	[include('examples_footer.lasso')]
</body>
</html>
